/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.anims;

import com.dfdyz.epicacg.efmextra.anims.ScanAttackAnimation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class DeferredDamageAttackAnimation
extends ScanAttackAnimation {
    public DeferredDamageAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        super(convertTime, antic, preDelay, contact, recovery, collider, colliderJoint, path, armature);
    }

    public DeferredDamageAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    public DeferredDamageAttackAnimation(float convertTime, String path, Armature armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    public DeferredDamageAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint scanner, String path, Armature model) {
        super(convertTime, antic, contact, recovery, hand, collider, scanner, path, model);
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    @Override
    public void attackTick(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this);
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entitypatch, elapsedTime);
        EntityState prevState = this.getState(entitypatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entitypatch;
            ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            LivingEntity target = entitypatch.getTarget();
            if (target != null) {
                entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
            }
        }
        if (prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) {
            this.ScanTarget(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        this.stateSpectrumBlueprint.newTimePair(phase.start, phase.preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).newTimePair(phase.preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).newTimePair(phase.start, phase.end).addState(EntityState.TURNING_LOCKED, (Object)true);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.removeHurtEntities();
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        entitypatch.removeHurtEntities();
    }
}

